"use strict";

var localizationCodes = {
  ruRU: {
    tag: 'ru-ru',
    urlTag: 'ru',
    code: 1049,
    nativeName: 'Русский',
    encoding: 'utf8'
  },
  enUS: {
    tag: 'en-us',
    urlTag: 'en',
    code: 1033,
    nativeName: 'English',
    encoding: 'utf8'
  },
  jaJP: {
    tag: 'ja-jp',
    urlTag: 'ja',
    code: 1041,
    nativeName: '日本語',
    encoding: 'utf8'
  },
  frFR: {
    tag: 'fr-fr',
    urlTag: 'fr',
    code: 1036,
    nativeName: 'Français (France)',
    encoding: 'utf8'
  },
  deDE: {
    tag: 'de-de',
    urlTag: 'de',
    code: 1031,
    nativeName: 'Deutsch',
    encoding: 'utf8'
  },
  itIT: {
    tag: 'it-it',
    urlTag: 'it',
    code: 1040,
    nativeName: 'Italiano',
    encoding: 'utf8'
  },
  esES: {
    tag: 'es-es',
    urlTag: 'es',
    code: 1034,
    nativeName: 'Español (España)',
    encoding: 'utf8'
  },
  esMX: {
    tag: 'es-mx',
    urlTag: 'es-MX',
    code: 2058,
    nativeName: 'Español (Mexico)',
    encoding: 'utf8'
  },
  ptBR: {
    tag: 'pt-br',
    urlTag: 'pt-BR',
    code: 1046,
    nativeName: 'Português (Brasil)',
    encoding: 'utf8'
  },
  trTR: {
    tag: 'tr-tr',
    urlTag: 'tr',
    code: 1055,
    nativeName: 'Türkçe',
    encoding: 'utf8'
  },
  plPL: {
    tag: 'pl-pl',
    urlTag: 'pl',
    code: 1045,
    nativeName: 'Polski',
    encoding: 'utf8'
  },
  csCZ: {
    tag: 'cs-cz',
    urlTag: 'cs',
    code: 1029,
    nativeName: 'Čeština',
    encoding: 'utf8'
  },
  koKR: {
    tag: 'ko-kr',
    urlTag: 'ko',
    code: 1042,
    nativeName: '한국어',
    encoding: 'utf8'
  },
  arAE: {
    tag: 'ar-ae',
    urlTag: 'ar',
    rtl: true,
    code: 14337,
    nativeName: 'العربية',
    encoding: 'utf8'
  },
  roRO: {
    tag: 'ro-ro',
    urlTag: 'ro',
    code: 1048,
    nativeName: 'Română',
    encoding: 'utf8'
  },
  kkKZ: {
    tag: 'kk-kz',
    urlTag: 'kk',
    code: 1087,
    nativeName: 'Қазақша',
    encoding: 'utf8'
  },
  zhHANS: {
    tag: 'zh-hans',
    urlTag: 'zh-Hans',
    code: 2052,
    nativeName: '中文(简体)',
    encoding: 'utf16le'
  },
  zhHANT: {
    tag: 'zh-hant',
    urlTag: 'zh-Hant',
    code: 1028,
    nativeName: '中文(台灣)',
    encoding: 'utf16le'
  },
  hashID: {
    tag: 'hash-id',
    urlTag: 'hash-id',
    code: 7777,
    nativeName: 'Hash ID',
    encoding: 'utf8'
  }
};
module.exports = localizationCodes;