module.exports = {
  eventNames: {
    forms: require('./event-names/forms'),
    tags: require('./event-names/tags'),
    wizardSteps: require('./event-names/wizard-steps'),
    wizards: require('./event-names/wizards'),
    activity: require('./event-names/activity'),
    tasks: require('./event-names/tasks'),
    reports: require('./event-names/reports'),
    groups: require('./event-names/groups'),
    devices: require('./event-names/devices'),
    servers: require('./event-names/servers'),
    licensing: require('./event-names/licensing'),
    appControl: require('./event-names/app-control'),
    vapm: require('./event-names/vapm'),
    distributionPoints: require('./event-names/distribution-points')
  },
  variableNames: {
    dependencies: require('./variable-names/dependencies'),
    pluginVariableNames: require('./variable-names/plugin-variable-names'),
    environments: require('./variable-names/environments'),
    tasks: require('./variable-names/tasks')
  },
  localization: {
    localizationCodes: require('./localization/localization-codes'),
    localizationEvents: require('./localization/localization-events'),
    weekDays: require('./localization/week-days')
  },
  plugin: {
    errors: require('./plugin/errors'),
    eulaTypes: require('./plugin/eula-types'),
    pluginObjectTypes: require('./plugin/plugin-obj-types'),
    pluginScope: require('./plugin/plugin-scope'),
    globalEvents: require('./plugin/global-events'),
    protectionStatus: require('./plugin/protection-status'),
    pluginSubTypes: require('./plugin/plugin-subtypes'),
    pluginFormPaths: require('./plugin/plugin-form-paths')
  },
  audit: {
    objectTypes: require('./audit/audit-object-types')
  },
  openApi: {
    limitedParameters: require('./open-api/limits'),
    errors: require('./open-api/errors'),
    serverVersions: require('./open-api/serverVersions')
  },
  errors: require('./errors'),
  enums: {
    osTypes: require('./enums/os-types'),
    taskStates: require('./enums/task-states'),
    taskStatesHistory: require('./enums/task-states-history'),
    events: require('./enums/events'),
    platformTypes: require('./enums/platform-types'),
    webConsoleTypes: require('./enums/web-console-types'),
    securityCenterHostedTypes: require('./enums/security-center-hosted-types'),
    cloudDBTypes: require('./enums/cloud-db-types'),
    errorTypes: require('./enums/error-types'),
    fileService: require('./enums/file-service')
  },
  defaults: require('./defaults'),
  prefixes: {
    redis: require('./prefixes/redis')
  }
}
