"use strict";

exports.__esModule = true;

var fs = require('fs');

module.exports = function initFeatureRegistry(featureFlagConfigMapPath) {
  if (featureFlagConfigMapPath === void 0) {
    featureFlagConfigMapPath = '';
  }

  var isFeatureEnabled = function (featureName) {
    try {
      var flagName_1 = "FEATURE_" + featureName;
      var featureFlags = JSON.parse(fs.readFileSync(featureFlagConfigMapPath));
      var matchedFeatureFlags = Object.keys(featureFlags).filter(function (flag) {
        var featureFlagRule = '^' + flag.replace(/\*/g, '.*') + '$';
        return new RegExp(featureFlagRule).test(flagName_1);
      });
      var isEnabled = Boolean(parseInt(featureFlags[matchedFeatureFlags.pop()])); // eslint-disable-next-line no-console

      console.log('featureRegistry::check::result', {
        featureName: featureName,
        flagName: flagName_1,
        isEnabled: isEnabled
      });
      return isEnabled;
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error('featureRegistry::check::error', {
        error: error
      });
      return false;
    }
  };

  return {
    isServerFeatureEnabled: function (_a) {
      var featureName = _a.featureName;
      return isFeatureEnabled(featureName);
    },
    isUserFeatureEnabled: function (_a, connection) {
      var featureName = _a.featureName;
      var _b = connection.kscUserId,
          userId = _b === void 0 ? '-' : _b,
          _c = connection.hostedInstanceId,
          securityCenterId = _c === void 0 ? '-' : _c,
          _d = connection.wsId,
          workspaceId = _d === void 0 ? '-' : _d;
      return isFeatureEnabled("USER_" + securityCenterId + "_" + workspaceId + "_" + userId + "_" + featureName);
    }
  };
};