const TokenConnection = require('./token-connection')
const PermanentConnection = require('./permanent-connection')
const UnauthorizedPermanentConnection = require('./unauthorized-permanent-connection')
const OAuthTokenConnection = require('./oauth-token-connection')

module.exports = (authType) => {
  switch (authType) {
    case 'token':
      return TokenConnection
    case 'connection':
      return PermanentConnection
    case 'unauthorized':
      return UnauthorizedPermanentConnection
    case 'oAuthToken':
      return OAuthTokenConnection
    default:
      return PermanentConnection
  }
}
