const { getInstance } = require('../open-api-client/async-actions-queue')

/**
 * Check status of async action
 * @param {Object} params
 * @param {string} params.wstrActionGuid - action`s identifier
 * @param {number} params.timeout - delay before next check
 * @param {Connection} connection
 * @return {Promise.<Object>} - info about finished or failed action
 */
module.exports = function asyncActionStateChecker ({
  wstrActionGuid
}, connection) {
  const asyncActionsQueue = getInstance()
  return asyncActionsQueue.getActionResult({ actionGuid: wstrActionGuid })
}
