module.exports = ({
  login,
  password,
  domain = '',
  isInternalUser = 0,
  wstrAuthKey,
  token,
  webToken,
  webConsoleToken,
  securityCode,
  isSuccessfullyConfirmedTotp,
  headers = {}
}) => {
  if (![0, 1, '0', '1'].includes(isInternalUser)) {
    throw new Error('Flag "isInternalUser" value is mismatch.')
  }
  const authHeaders = {}
  if (wstrAuthKey) {
    authHeaders.Authorization = `KSCGW ${wstrAuthKey}`
  } else if (isSuccessfullyConfirmedTotp) {
    authHeaders.Authorization = 'KSCMFA totpregistered="1"'
  } else if (securityCode) {
    authHeaders.Authorization = `KSCMFA totp="${securityCode}"`
  } else if (token) {
    authHeaders.Authorization = `KSCT ${token}`
  } else if (webToken) {
    authHeaders.Authorization = `KSCWT ${webToken}`
  } else if (webConsoleToken) {
    authHeaders.Authorization = `KSCNT ${JSON.stringify(webConsoleToken)}`
  } else if (headers.authorization) {
    authHeaders.Authorization = headers.authorization
  } else if (login || password || domain) {
    const loginParams = []
    if (login) {
      loginParams.push(`user="${base64Enconde(login)}"`)
    }
    if (password) {
      loginParams.push(`pass="${base64Enconde(password)}"`)
    }
    if (domain) {
      loginParams.push(`domain="${base64Enconde(domain)}"`)
    }
    authHeaders.Authorization = `KSCBasic internal="${isInternalUser}", ${loginParams.join(', ')}`
  }

  return Object.assign(authHeaders, headers)
}

function base64Enconde (str) {
  return Buffer.from(str).toString('base64')
}
