const crypto = require('crypto')

const BYTES_COUNT = 8

function getRequestIdHeader ({ uid, clientUid }) {
  const traceId = Buffer.from(clientUid ?? uid)
                    .toString('hex')
                    .slice(0, BYTES_COUNT * 2)
                    .padEnd(BYTES_COUNT * 2, 0)
                    .toUpperCase()
  const spanId = crypto
                    .randomBytes(BYTES_COUNT)
                    .toString('hex')
                    .toUpperCase()
  return { 'X-KSC-RequestId': `${traceId}_${spanId}` }
}

module.exports = ({ connection, headers = {} }) => {
  return {
    ...headers,
    ...connection.customHeaders,
    ...getRequestIdHeader(connection)
  }
}
