const BaseOpenAPIClient = require('./base-open-api-client.js')

/**
 * Base methods for communication with Open API server.
 */
class BaseOpenAPIGatewayClient extends BaseOpenAPIClient {
    /**
     * Send http request using FIFO queue
     * @param {object} params
     * @param {string} params.command - backend action name
     * @param {string} params.httpMethod - http request method
     * @param {object} params.data - request body data
     * @param {object} params.headers - custom request headers
     * @param {connectionId} params.id of connection that request should be send over
     * @return {Promise}
     */
  async baseRequest ({ command, httpMethod, data, headers, connectionId } = {}) {
    const { connectionPool } = require('@kl/openapi-client') // Почему тут а не в верху файла? Потому, что на момент чтения файла нужного состояния connectionPool еще нет.
    let connection = await connectionPool.getConnection(connectionId)
    return super.baseRequest({ command, httpMethod, data, headers, connection })
  }
}

module.exports = BaseOpenAPIGatewayClient
