const onRequestHooks = require('./on-request-hooks')
const onResponseHooks = require('./on-response-hooks')

function processRequest () {
  return onRequestHooks.reduce(
    async (acc, hook) => {
      const { props, request } = await acc
      try {
        const props = await request
        return Promise.resolve({ request: hook(props), props })
      } catch (err) {
        runtime.logger.error('Error on request hook: ', err)
        return Promise.resolve({ props, request })
      }
    },
    { request: Promise.resolve(...arguments), props: null }
  ).then(({ request }) => request)
}

function processResponse ({
  sourceRequest,
  response,
  options,
  logger
}) {
  return onResponseHooks.reduce(
    async (acc, hook) => {
      const { props, response } = await acc
      try {
        const props = await response
        return Promise.resolve({ response: hook({ sourceRequest, response: props, options, logger }), props })
      } catch (err) {
        runtime.logger.error('Error on response hook: ', err)
        return Promise.resolve({ props, response, logger })
      }
    },
    { response, props: null }
  ).then(({ response }) => response)
}

module.exports = {
  onRequestHooks,
  onResponseHooks,
  processRequest,
  processResponse
}
