const IteratorsQueue = require('./iterators-queue')
const DataStore = require('@kl/temp-data-store/in-memory')

const ITERATORS = {
  LIMIT: Number(process.env.ITERATORS_LIMIT) || 30,
  OPEN_METHODS: [
    'SrvView.ResetIterator',
    'AdHosts.FindAdGroups',
    'AdHosts.GetChildOUs',
    'AdHosts.GetChildComputers',
    'HostGroup.FindHosts',
    'HostGroup.FindGroups',
    'HostGroup.FindUsers',
    'HostGroup.FindIncidents',
    'HstAccessControl.FindRoles'
  ],
  CLOSE_METHODS: [
    'SrvView.ReleaseIterator',
    'ChunkAccessor.Release'
  ]
}

/**
 * @type IteratorsQueue | null
 */
let queue = null

module.exports = {
  ITERATORS,
  init ({
    onIteratorsLimitExceededCallbacks = [],
    tempDataStore = new DataStore(),
    onIteratorsQueueCreated = null
  } = {}) {
    queue = new IteratorsQueue({
      tempDataStore,
      onLimitExceededCallbacks: onIteratorsLimitExceededCallbacks,
      openApiClient: require('../../../open-api-client')
    })
    onIteratorsQueueCreated && onIteratorsQueueCreated(queue)
  },
  getQueue () {
    return queue
  }
}
