const { ITERATORS, getQueue } = require('.')

module.exports = async function iteratorQueueRequestHook (data) {
  const { command, connection, requestId } = data
  if (ITERATORS.OPEN_METHODS.includes(command)) {
    const queue = getQueue()
    const { clientUid } = connection
    const iterators = await queue.getIteratorsForUser(clientUid)
    if (iterators.length < ITERATORS.LIMIT) {
      const iteratorPlaceholder = { clientUid, requestId }
      await queue.pushIteratorPlaceholder(iteratorPlaceholder)
      runtime.logger.log('queue.pushIteratorPlaceholder', iteratorPlaceholder)
    } else {
      await queue.onLimitExceeded({ connection })
      if (Array.isArray(iterators)) {
        const iteratorsToLog = iterators.join('\r\n')
        runtime.logger.error('Iterators caused limitation exceed: ', iteratorsToLog)
      }
      return {
        ...data,
        error: new Error('Iterators limit exceeded')
      }
    }
  }

  return data
}
