const { ITERATORS, getQueue } = require('.')

module.exports = async function iteratorQueueResponseHook ({
  response,
  sourceRequest: {
    command,
    requestId,
    connection: { clientUid },
    data
  }
}) {
  if (ITERATORS.OPEN_METHODS.includes(command)) {
    const queue = getQueue()
    const iteratorPlaceholder = { clientUid, requestId }
    await queue.removeIteratorPlaceholder(iteratorPlaceholder)
    runtime.logger.log('queue.removeIteratorPlaceholder', iteratorPlaceholder)
    const { body: { PxgError: error = null } = {} } = response
    if (!error) {
      const iteratorToPush = { clientUid, command, response }
      await queue.pushIterator(iteratorToPush)
      runtime.logger.log('queue.pushIterator', { ...iteratorToPush, response: response.body })
    }
  } else if (ITERATORS.CLOSE_METHODS.includes(command)) {
    const queue = getQueue()
    const { body: { PxgError: error = null } = {} } = response
    const { wstrIteratorId = null, strAccessor = null } = data
    if (!error) {
      const iteratorToRemove = { clientUid, command, iterator: wstrIteratorId || strAccessor }
      await queue.removeIterator(iteratorToRemove)
      runtime.logger.log('queue.removeIterator', iteratorToRemove)
    }
  }

  return response
}
