const { getInstance } = require('../async-actions-queue')
const asyncActionCommands = require('../async-action-commands')
const asyncActionCommandsList = Object.keys(asyncActionCommands)
const iteratorsQueueRequestHook = require('./iterator-hooks/queue/request-hook')

const processAsyncActionRequest = async data => {
  if (asyncActionCommandsList.includes(data.command)) {
    const asyncActionsQueue = getInstance()
    asyncActionsQueue.createAction(data)
    await asyncActionsQueue.isReady(data)
  }
  return data
}

module.exports = [
  processAsyncActionRequest,
  iteratorsQueueRequestHook
]
