const { getInstance } = require('../async-actions-queue')
const asyncActionCommands = require('../async-action-commands')
const asyncActionCommandsList = Object.keys(asyncActionCommands)
const iteratorsQueueResponseHook = require('./iterator-hooks/queue/response-hook')

async function processAsyncActionResponse (data) {
  const { command } = data.sourceRequest
  if (asyncActionCommandsList.includes(command)) {
    const actionGuidGetter = asyncActionCommands[command]
    const actionGuid = actionGuidGetter(data.response)
    const asyncActionsQueue = getInstance()
    asyncActionsQueue.processResponse({ ...data, actionGuid })
  }

  return data.response
}

module.exports = [
  processAsyncActionResponse,
  iteratorsQueueResponseHook
]
