const hooks = require('./hooks')
const { init: initIteratorsQueue } = require('./hooks/iterator-hooks/queue')
const { init: initAsyncActionsQueue } = require('./async-actions-queue')

module.exports = function init ({
  onRequestHooks = [],
  onResponseHooks = [],
  ...data
} = {}) {
  hooks.onRequestHooks.push(...onRequestHooks)
  hooks.onResponseHooks.push(...onResponseHooks)
  initIteratorsQueue(data)
  initAsyncActionsQueue(data)
}
