const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'AdHosts'

module.exports = class AdHosts extends BaseOpenAPIClient {

  async FindAdGroups ({
    vecFieldsToReturn = [
      'adhst_adgroup_id',
      'adhst_adgroup_distinguished_name',
      'adhst_adgroup_name',
      'adhst_adgroup_sam_name',
    ],
    vecFieldsToOrder = [],
    pOptions = {},
    lMaxLifeTime = 7200
  }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.FindAdGroups`,
      data: this.serialize({
        vecFieldsToReturn,
        vecFieldsToOrder,
        pOptions,
        lMaxLifeTime
      }),
      connection
    }, cacheConfig)
    return this.deserialize(body, 'wstrIterator')
  }

  async GetChildOUs ({
    idOU = 0,
    pFields = [
      'adhst_id',
      'adhst_idParent',
      'adhst_idComputer',
      'adhst_binOu',
    ],
    lMaxLifeTime = 7200,
  }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetChildOUs`,
      data: this.serialize({
        idOU,
        pFields,
        lMaxLifeTime,
      }),
      connection
    }, cacheConfig)
    return this.deserialize(body, 'PxgRetVal')
  }

  async GetOU ({
    idOU,
    pFields = [
      'adhst_id',
      'adhst_enable_ad_scan',
      'adhst_idComputer'
    ]
  }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetOU`,
      data: this.serialize({
        idOU,
        pFields
      }),
      connection
    }, cacheConfig)
    return this.deserialize(body, 'PxgRetVal')
  }

  async UpdateOU ({
    idOU,
    pData
  }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.UpdateOU`,
      data: {
        idOU,
        pData
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Acquire list of hosts located in "Unassigned computers" for specified OU
   * @param idOU - id of organization unit
   * @param vecFieldsToReturn - fields names to acquire
   * @param lMaxLifeTime - max result-set lifetime in seconds, not more than 7200
   * @returns {Promise<string>} - result-set ID
   * @constructor
   */
  async GetChildComputers ({ idOU, vecFieldsToReturn = [], lMaxLifeTime = 7200 }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetChildComputers`,
      data: {
        idOU,
        vecFieldsToReturn,
        lMaxLifeTime
      },
      connection
    }, cacheConfig)
    return this.deserialize(body, 'PxgRetVal')
  }
}
