const BaseOpenApiClient = require('../base-open-api-client')
const className = 'AdmServerSettings'

module.exports = class AdmServerSettings extends BaseOpenApiClient {
  /**
   * Change shared folder
   * @param {object} params
   * @param {wstrNetworkPath} params.wstrNetworkPath network path to shared folder
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<String>} id of asynchronous operation
   */
  ChangeSharedFolder ({ wstrNetworkPath } = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ChangeSharedFolder`,
      data: {
        wstrNetworkPath
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }
}
