const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'AKPatches'

/**
 * @class
 * @classdesc Interface to manage system of autoupdating by patch.exe patches.
 * @extends BaseOpenAPIClient
 */
module.exports = class AKPatches extends BaseOpenAPIClient {
  /**
   * @method
   * @description Notify that the Cloud Wizard has been started.
   * @param {{ szwPatchId: string, parOptions: any }} params - object containing function arguments. Consists of:
   * – szwPatchId – The patch identifier
   * – parOptions – object containing additional parameters:
   *   — NeedBackupServer – true if is required to do SC-server backup before installation of the patch, optional
   * @param {Connection} connection – Connection object.
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {any} ppResult – contains following attributes:
   * — CallResult — true if success
   * — ErrorDescription — error description, empty if no error
   */
  async ApprovePatch ({ szwPatchId, parOptions = null }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.ApprovePatch`,
      data: {
        szwPatchId,
        parOptions: this.serialize(parOptions)
      },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }

  /**
   * @method
   * @description Forbid installation of the patch.
   * After this forbidden will be no more notifications that this patch expecting approval on installation
    * @param {{ szwPatchId: string, parOptions: any }} params - object containing function arguments. Consists of:
   * – szwPatchId – The patch identifier
   * – parOptions – reserved
   * @param {Connection} connection - Connection object.
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {any} ppResult – contains following attributes:
   * — CallResult — true if success
   * — ErrorDescription — error description, empty if no error
   */
  async ForbidPatch ({ szwPatchId, parOptions = null }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.ForbidPatch`,
      data: {
        szwPatchId,
        parOptions: this.serialize(parOptions)
      },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }
}
