const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'AppCtrlApi'

module.exports = class AppCtrlApi extends BaseOpenAPIClient {

  /**
   * Get data about instances of the execution file on the host.
   * 
   * @param {szwHostId: string, IFileID: long, pFilter: params} data - request params such as host id and list of fields to return
   * @param {Connection} connection 
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns list of attributes of executable file
   */
  async GetExeFileInfo ({lFileId, szwHostId, pFilter = null}, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetExeFileInfo`,
      data: {
        lFileId,
        szwHostId,
        pFilter
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }
}
