const BaseOpenAPIClient = require('../base-open-api-client')
const prepareAuthHeaders = require('../../helpers/auth-headers')
/**
 * Аутентификация пользователя
 */
module.exports = class Auth extends BaseOpenAPIClient {
  constructor (...args) {
    super(...args)
    this.isPublicInterface = false
  }

  /**
   * Аутентификация пользователя на Open API сервере
   * @param {object} params
   * @param {string} params.login - логин внутреннего KSC или доменного пользователя
   * @param {string} params.password - пароль
   * @param {string} params.domain - имя виртуального сервера
   * @param {boolean} params.isInternalUser - флаг, является ли пользователь внутрениим или доменным
   * @param {Connection} connection - TCP connection with Open API server
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @param {string} wstrAuthKey - one-time authentication key, special type of authentication used to create gateway connections
   * @param {string} token - authorization token, generated to temporarily grant access to KSC without exposing credentials
   * @param {string} webToken - authentication token obtained from Kaspersky UIS
   * @return {Promise}
   */
  login (params, connection, cacheConfig) {
    const headers = prepareAuthHeaders(params)
    return this.baseRequest({ command: 'login', headers, connection }, cacheConfig)
  }
}
