const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'CertPoolCtrl'

module.exports = class CertPoolCtrl extends BaseOpenAPIClient {
  /**
   *
   * @description Returns information about certificate from server's certificates pool.
   * @param {object} vServer
   * @param {Number} vServer.nVServerId Virtual server id (-1 for current, 0 for main server)
   * @param {Number} vServer.nFunction Certificate function (see "KLCERTP::CertificateFunction enum values")
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise}
   */
  GetCertificateInfo ({nVServerId, nFunction}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetCertificateInfo`,
      data: {nVServerId, nFunction},
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  /**
   *
   * @description Sets certificate of a given function for a given virtual server.
   * @param {object} vServer
   * @param {Number} vServer.nVServerId Virtual server id (-1 for current, 0 for main server)
   * @param {Number} vServer.nFunction Certificate function (see "KLCERTP::CertificateFunction enum values")
   * @param {object} vServer.pCertData Params with certificate data (see Common format for certificate params). If pCertData is empty or NULL, then certificate will be deleted.
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise}
   */
  SetCertificate ({nVServerId, nFunction, pCertData}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetCertificate`,
      data: {
        nVServerId, nFunction, pCertData
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }
}
