const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'CgwHelper'

module.exports = class CgwHelper extends BaseOpenAPIClient {
  GetSlaveServerLocation ({ nSlaveServerId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetSlaveServerLocation`,
      data: {
        nSlaveServerId
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  GetNagentLocation ({ wsHostName }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetNagentLocation`,
      data: {
        wsHostName
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }
}
