const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ChunkAccessor'

module.exports = class ChunkAccessor extends BaseOpenAPIClient {
  GetItemsChunk ({ strAccessor, nStart = 0, nCount }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetItemsChunk`,
      data: {
        strAccessor, nStart, nCount
      },
      connection
    }, cacheConfig).then(({ body }) => {
      const result = body?.pChunk?.KLCSP_ITERATOR_ARRAY || []
      return { result }
    }).then((res) => this.deserialize({ body: { PxgRetVal: res.result } }))
  }
  GetItemsCount ({ strAccessor }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetItemsCount`,
      data: { strAccessor },
      connection
    }, cacheConfig).then(this.getResult)
  }
  Release ({ strAccessor }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.Release`,
      data: { strAccessor },
      connection
    }, cacheConfig).then(this.getBody)
  }
}
