const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'CloudAccess'

module.exports = class CloudAccess extends BaseOpenAPIClient {
  /**
   * Check key-pair access
   * @param {object} params
   * @param {number} params.enCloudType - Type of the cloud infrastructure being accessed
   * @param {object} params.pKeyPair
   * @param {string} params.pKeyPair.CLIENT_ID - AWS - IAM user name. Azure - Subscription ID
   * @param {string} params.pKeyPair.CLIENT_SECRET - Secret key string encrypted with ProtectPassword
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<*>}
   */
  async AcquireAccessForKeyPair ({ enCloudType, pKeyPair }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.AcquireAccessForKeyPair`,
      data: {
        enCloudType,
        pKeyPair
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  /**
   * Verify pcloud credentials (Google cloud and AWs not supported)
   * @param {object} params
   * @param {number} params.enCloudType - Type of the cloud infrastructure being accessed
   * @param {object} params.pKeyPair
   * @param {string} params.pKeyPair.CLIENT_ID - Subscription ID
   * @param {string} params.pKeyPair.AZURE_APP_ID - Application ID
   * @param {string} params.pKeyPair.CLIENT_SECRET - Application authentication key, must be protected globaly as UTF8 string
   * @param {string} params.pKeyPair.AZURE_STORAGE_NAME - Storage account name
   * @param {string} params.pKeyPair.AZURE_STORAGE_KEY - Storage account key, must be protected globaly as UTF8 string
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<*>}
   */
  async VerifyCredentials ({ enCloudType, pKeyPair }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.VerifyCredentials`,
      data: {
        enCloudType,
        pKeyPair
      },
      connection
    }, cacheConfig)
    return this.getResult(body)
  }
}
