const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ConEvents'

module.exports = class ConEvents extends BaseOpenAPIClient {
  /**
   * Methods with disabled logging
   * @returns {[]}
   */
  get loggingDisabledMethods () {
    return ['Retrieve']
  }

  /**
   * Check any service console availability
   * @param {null} params - this method doesn't receive any params
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<boolean>}
   */
  async IsAnyServiceConsoleAvailable (params = null, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.IsAnyServiceConsoleAvailable`,
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Check service console availability
   * @param {object} params
   * @param {string} params.wstrProdName - product name
   * @param {string} params.wstrProdVersion - product version
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<boolean>}
   */
  async IsServiceConsoleAvailable ({ wstrProdName, wstrProdVersion }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.IsServiceConsoleAvailable`,
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Retrieve events
   * @param {null} params - this method doesn't receive any params
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<Object>}
   */
  async Retrieve (params, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.Retrieve`,
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * Subscribe on event
   * @param {object} params
   * @param {string} params.wstrEvent - event type
   * @param {object} params.pFilter - event filter
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<Object>}
   */
  async Subscribe ({ wstrEvent, pFilter }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.Subscribe`,
      data: { wstrEvent, pFilter },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * UnSubscribe from event
   * @param {object} params
   * @param {number} params.nSubsId - subscription id
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async UnSubscribe ({ nSubsId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.UnSubscribe`,
      data: { nSubsId },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
