const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'DataProtectionApi'

module.exports = class DataProtectionApi extends BaseOpenAPIClient {
  CheckPasswordSplPpc ({ szwPassword }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CheckPasswordSplPpc`,
      data: {
        szwPassword
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  ProtectDataForHost ({ szwHostId, pData }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ProtectDataForHost`,
      data: { szwHostId, pData },
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pDataProtected'))
  }

  ProtectDataGlobally ({ pData }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ProtectDataGlobally`,
      data: { pData },
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pDataProtected'))
  }

  ProtectUtf8StringForHost ({ szwHostId, szwPlainText }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ProtectUtf8StringGlobally`,
      data: {
        szwHostId,
        szwPlainText
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  ProtectUtf8StringGlobally ({ szwPlainText }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ProtectUtf8StringGlobally`,
      data: {
        szwPlainText
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  ProtectUtf16StringForHost ({ szwHostId, szwPlainText }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ProtectUtf16StringForHost`,
      data: {
        szwHostId,
        szwPlainText
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  ProtectUtf16StringGlobally ({ szwPlainText }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ProtectUtf16StringGlobally`,
      data: {
        szwPlainText
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }
}
