const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'DpeKeyService'

module.exports = class DpeKeyService extends BaseOpenAPIClient {
  /**
   * Returns information about host and key for chosen encrypted device.
   *
   * @param {object} opts container for arguments
   * @param { String } opts.wstrDeviceId Device id
   * @param {*} connection connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns { Array } Array of params with key info. See Srvview encrypted devices on hosts.
   * The difference is that the key is decrypted.
   */
  async GetDeviceKeys3 ({ wstrDeviceId = '' } = {}, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetDeviceKeys3`,
      data: {
        wstrDeviceId
      },
      connection
    }, cacheConfig)
    return this.getResult(body, 'pKeyInfos')
  }
}
