const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'EventNotificationProperties'

module.exports = class EventNotificationProperties extends BaseOpenAPIClient {
  /**
   * Reads the default the notification settings, such as SMTP server properties, etc.
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>} - object containing the current notification settings
   * @constructor
   */
  GetDefaultSettings (args, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.GetDefaultSettings`, connection }, cacheConfig)
      .then(this.getResult)
  }

  /**
   * Reads the notification limits
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>} - object containing the current notification limits
   * @constructor
   */
  GetNotificationLimits (args, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.GetNotificationLimits`, connection }, cacheConfig)
      .then(this.getResult)
  }

  /**
   * Allows to setup the default the notification settings, such as SMTP server properties, etc.
   * @param pSettings - object containing the notification settings to be set
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>}
   * @constructor
   */
  SetDefaultSettings ({ pSettings }, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.SetDefaultSettings`, data: { pSettings: this.serialize(pSettings) }, connection }, cacheConfig)
      .then(this.getResult)
  }

  /**
   * Allows to setup notification limits
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>} - object containing the notification limits to be set
   * @constructor
   */
  SetNotificationLimits ({ pSettings }, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.SetNotificationLimits`, data: { pSettings: this.serialize(pSettings) }, connection }, cacheConfig)
      .then(this.getResult)
  }

  /**
   * Allows to test the notification settings, such as SMTP server properties, etc. by sending a test notification using
   * the provided notification settings
   * @param {object} params
   * @param {number} params.eType - type of the notification to be tested
   * @param {object} params.pSettings - object containing the notification settings to be tested
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   * @constructor
   */
  TestNotification ({ eType, pSettings }, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.TestNotification`, data: { eType, pSettings: this.serialize(pSettings) }, connection }, cacheConfig)
      .then(this.getResult)
  }
}
