const baseOpenAPIClient = require('../base-open-api-client')
const className = 'EventProcessingFactory'

module.exports = class EventProcessingFactory extends baseOpenAPIClient {
  /**
   * Create event processing iterator
   * @param {object} params
   * @param {Array.<String>} params.vecFieldsToReturn - array of attribute names to return
   * @param {Array.<Object>} params.vecFieldsToOrder - array of containers with sorting params
   * @param {number} params.lifetimeSec - max result-set lifetime in seconds
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   * @constructor
   */
  CreateEventProcessing ({ vecFieldsToReturn, vecFieldsToOrder = [], lifetimeSec = 1000 } = {}, connection, cacheConfig) {
    const options = {
      command: `${className}.CreateEventProcessing`,
      data: {
        vecFieldsToReturn, vecFieldsToOrder, lifetimeSec
      },
      connection
    }
    return this.baseRequest(options, cacheConfig)
      .then(body => this.getResult(body, 'strIteratorId'))
  }

  /**
   * Create event processing iterator
   * @param {object} params
   * @param {object} params.pFilter - object containing values for attributes to filter events
   * @param {Array.<String>} params.vecFieldsToReturn - array of attribute names to return
   * @param {Array.<Object>} params.vecFieldsToOrder - array of containers with sorting params
   * @param {number} params.lifetimeSec - max result-set lifetime in seconds
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   * @constructor
   */
  CreateEventProcessing2 ({ pFilter, vecFieldsToReturn, vecFieldsToOrder = [], lifetimeSec = 1000 } = {}, connection, cacheConfig) {
    const options = {
      command: `${className}.CreateEventProcessing2`,
      data: {
        pFilter,
        vecFieldsToReturn,
        vecFieldsToOrder,
        lifetimeSec
      },
      connection
    }
    return this.baseRequest(options, cacheConfig)
      .then(body => this.getResult(body, 'strIteratorId'))
  }

  /**
   * Создание итератора для обработки событий хоста
   * @param {object} params
   * @param {string} params.strDomainName - домен устройства (KLHST_WKS_WINDOMAIN)
   * @param {string} params.strHostName - имя устройства (KLHST_WKS_HOSTNAME)
   * @param {string} params.strProduct - идентификатор продукта
   * @param {string} params.strVersion - версия продукта
   * @param {object} params.pFilter - фильтры
   * @param {number} params.lifetimeSec - длительность сессии
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<{result}|*>}
   * @constructor
   */
  async CreateEventProcessingForHost2 ({ strDomainName, strHostName, strProduct, strVersion, pFilter = {}, vecFieldsToReturn, vecFieldsToOrder = [], lifetimeSec = 1000 }, connection, cacheConfig) {
    const options = {
      command: `${className}.CreateEventProcessingForHost2`,
      data: {
        strDomainName,
        strHostName,
        strProduct,
        strVersion,
        pFilter,
        lifetimeSec,
        vecFieldsToReturn,
        vecFieldsToOrder
      },
      connection
    }
    const body = await this.baseRequest(options, cacheConfig)
    return this.getResult(body, 'strIteratorId')
  }
}
