const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ExtTenant'

/**
 * Provide an interface for working with the ExtTenant subsystem.
 * Manage external tenant info interface.
*/
module.exports = class ExtServerTenant extends BaseOpenAPIClient {
  constructor (...args) {
    super(...args)
    this.isPublicInterface = false
  }

  /**
  * @description Sets external tenant id.
  * @param {nVServerId} nVServerId - VServer Id. 0 for main server, -1 for current connected vserver
  * @param {wstrTenantID} wstrTenantID - Tennant Id. Empty string means "reset to default". Max length 128 chars.
  * @param {Connection} connection
  * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
  * @return {Promise.<object>}
  */
   SetExternalTenantId ({ nVServerId, wstrTenantID  } = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetExternalTenantId`,
      data: { nVServerId, wstrTenantID },
      connection
    }, cacheConfig)
      .then(this.getResult)

  }
}
