const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ExtTenant'

/**
 * Provide an interface for working with the ExtTenant subsystem.
 * Manage external tenant info interface.
*/
module.exports = class ExtTenant extends BaseOpenAPIClient {
  /**
  * @description Gets  external tenant id.
   * @param {object} params
  * @param {nVServerId} params.nVServerId - VServer Id. 0 for main server, -1 for current connected vserver
  * @param {Connection} connection
  * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
  * @return {Promise.<object>}  Tennant Id. Max length 128 chars. 
  */
   GetExternalTenantId  ({ nVServerId  } = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetExternalTenantId`,
      data: { nVServerId },
      connection
    }, cacheConfig)
    .then(this.getResult)
  }
}
