const BaseOpenApiClient = require('../base-open-api-client')
const className = 'GroupSyncIterator'

module.exports = class GroupSyncIterator extends BaseOpenApiClient {
  /**
   * @deprecated
   */
  async getAllItems (params) {
    const { body: { lKeyCount, wstrIterator } } = await this.baseRequest(params)
    const items = await this.baseRequest({
      command: 'GroupSyncIterator.GetNextItems',
      data: { nCount: lKeyCount, szwIterator: wstrIterator },
      connection: params.connection
    })
    await this.baseRequest({
      command: 'GroupSyncIterator.ReleaseIterator',
      data: { szwIterator: wstrIterator },
      connection: params.connection
    })
    items.body.PxgRetVal = items.body.pData.KLCSP_ITERATOR_ARRAY
    return items
  }

  /**
   * Acquire subset of elements contained in the result-set
   * @param {object} params
   * @param {string} params.szwIterator - forward iterator id
   * @param {number} params.nCount - number of elements to return
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {*} - nCount elements contained in the specified result-set beginning
   * from the current position and moves internal pointer to the new position
   */
  async GetNextItems ({ szwIterator, nCount = 50 }, connection, cacheConfig) {
    const result = await this.baseRequest({
      command: `${className}.GetNextItems`,
      data: {
        szwIterator,
        nCount
      },
      connection
    }, cacheConfig)
    return result.body
  }

  /**
   * Releases the result-set
   * @param {object} params
   * @param {string} params.szwIterator - result-set ID
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async ReleaseIterator ({ szwIterator }, connection, cacheConfig) {
    const result = await this.baseRequest({
      command: `${className}.ReleaseIterator`,
      data: {
        szwIterator
      },
      connection
    }, cacheConfig)
    return this.getResult(result)
  }
}
