const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'GuiContext'

module.exports = class GuiContext extends BaseOpenAPIClient {

  /**
   * Sets up language for the current session.
   * @param {object} params
   * @param {string} params.pwchIetfLanguageTag IETF language tag (e.g. ru-RU)
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
    async SetLanguage ({pwchIetfLanguageTag}, connection, cacheConfig) {
        const body = await this.baseRequest({
            command: `${className}.SetLanguage`,
            data: {
                pwchIetfLanguageTag
            },
            connection
        }, cacheConfig)
        return this.getBody(body)
    }

}
