const BaseOpenAPIClient = require('../base-open-api-client')
const SrvViewClass = require('./srv-view')
const SrvView = new SrvViewClass()
const _ = require('lodash')

module.exports = class Helpers extends BaseOpenAPIClient {
  constructor () {
    super()
    this.cache = {
      SrvViewCachedFetch: {}
    }
  }
  async SrvViewSilentFetch (params, connection, cacheConfig) {
    const result = await SrvView.Fetch(params, connection, cacheConfig)
    return result
  }
  async SrvViewCachedFetch (params, connection, cacheConfig) {
    let timeToLive = 5 * 60 * 1000
    let now = Date.now()
    let cacheSlot = this.cache.SrvViewCachedFetch[params.wstrViewName] || {}
    if (_.isEmpty(cacheSlot) || cacheSlot.timestamp + timeToLive < now) {
      cacheSlot = {
        data: await SrvView.Fetch(params, connection, cacheConfig),
        timestamp: now
      }
    }
    this.cache.SrvViewCachedFetch[params.wstrViewName] = cacheSlot
    return cacheSlot.data
  }
}
