const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'HostMoveRules'

module.exports = class HostMoveRules extends BaseOpenAPIClient {
  GetRules ({ pFields }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetRules`,
      data: {
        pFields
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  AddRule ({ pRuleInfo }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.AddRule`,
      data: {
        pRuleInfo: this.serialize(pRuleInfo)
      },
      connection
    }, cacheConfig)
    .then(this.getResult)
  }

  GetRule ({ nRule }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetRule`,
      data: {
        nRule
      },
      connection
    }, cacheConfig)
    .then(this.deserialize)
  }

  DeleteRule ({ nRule }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DeleteRule`,
      data: {
        nRule
      },
      connection
    }, cacheConfig)
    .then(this.getResult)
  }

  SetRulesOrder ({ pRules = [] }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetRulesOrder`,
      data: {
        pRules
      },
      connection
    }, cacheConfig)
    .then(this.getResult)
  }

  UpdateRule ({ nRule, pRuleInfo }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.UpdateRule`,
      data: {
        nRule,
        pRuleInfo: this.serialize(pRuleInfo)
      },
      connection
    }, cacheConfig)
    .then(this.getResult)
  }

  ExecuteRulesNow ({ nGroupId, pRules, nOptions }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ExecuteRulesNow`,
      data: {
        nGroupId,
        pRules,
        nOptions
      },
      connection
    }, cacheConfig)
    .then(this.getBody)
  }
}
