const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'HostTagsRulesApi'

module.exports = class HostTagsRulesApi extends BaseOpenAPIClient {
  
  GetRules ({ pFields2ReturnArray }, connection, cacheConfig) {
    return this.baseRequest({
                              command: `${className}.GetRules`,
                              data: { pFields2ReturnArray },
                              connection
                            }, cacheConfig)
               .then(this.deserialize)
  }
  
  UpdateRule ({ szwTagValue, pRuleInfo }, connection, cacheConfig) {
    let rulesInfo = this.serialize(pRuleInfo)
    return this.baseRequest({
                              command: `${className}.UpdateRule`,
                              data: { szwTagValue, pRuleInfo: rulesInfo },
                              connection
                            }, cacheConfig)
               .then(this.deserialize)
  }
  
  DeleteRule ({ szwTagValue }, connection, cacheConfig) {
    return this.baseRequest({
                              command: `${className}.DeleteRule`,
                              data: { szwTagValue },
                              connection
                            }, cacheConfig)
               .then(this.deserialize)
  }
  
  ExecuteRule ({ szwTagValue }, connection, cacheConfig) {
    return this.baseRequest({
                              command: `${className}.ExecuteRule`,
                              data:    { szwTagValue },
                              connection
                            }, cacheConfig)
               .then(this.getBody)
  }
  
}