const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'HWInvStorage'

module.exports = class HWInvStorage extends BaseOpenAPIClient {

  GetHWInvObject ({ nObjId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetHWInvObject`,
      data: { nObjId },
      connection
    }, cacheConfig)
    .then(body => this.getResult(body, 'pObj'))
  }

  SetHWInvObject ({ nObjId, pObj }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetHWInvObject`,
      data: { nObjId, pObj },
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

  EnumDynColumns ( noParam , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.EnumDynColumns`,
      data: { },
      connection
    }, cacheConfig)
    .then(this.getBody)
  }

  AddHWInvObject ( { pObj } , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.AddHWInvObject`,
      data: { pObj },
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

  DelHWInvObject2 ( { arrObjId } , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DelHWInvObject2`,
      data: { arrObjId },
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

  AddDynColumn ( { wstrColName } , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.AddDynColumn`,
      data: { wstrColName },
      connection
    }, cacheConfig)
    .then(this.getBody)
  }

  DelDynColumn ( { wstrColId } , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DelDynColumn`,
      data: { wstrColId },
      connection
    }, cacheConfig)
    .then(body => this.getResult(body, 'arrDynColumnInfo'))
  }

  GetProcessingRules ( noParam , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetProcessingRules`,
      data: {  },
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pRules'))
  }

  SetProcessingRules ( { pRules } , connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetProcessingRules`,
      data: { pRules },
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pRules'))
  }

}
