const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'IVapmSrvService'

module.exports = class IVapmSrvService extends BaseOpenAPIClient {
  /**
   * Software inventory product automatic update state change method (via VAPM facilities)
   *
   * @param {object} params
   * @param {*} params.parProd params with products to change their automatic update state in the following form:
   *                        name of the parameter == Software Inventory's product id (wstring)
   *                        value of the parameter == desirable automatic update state (int). Enum values:
   *                            0: Undefined
   *                            1: Enabled
   *                            2: Disabled
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  SetProductAutoUpdateState ({ parProd }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetProductAutoUpdateState`,
      data: { parProd },
      connection
    }, cacheConfig).then(this.deserialize)
  }
}
