const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'IWebSrvSettings'

module.exports = class IWebSrvSettings extends BaseOpenAPIClient {
  /**
     * @description Returns information about custom certificate.
     * @description If cert present then it return params with [["CERT_TYPE"] == 0 (PEM form)] and ["CERT_PUBLIC_PART"] fields.
     * @description In case if certificate not set, then it returns empty params with no any fields.
     * @param {*} { args } Empty params
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns
     */
  GetCertificateInfo ({ args }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetCertificateInfo`,
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

  /**
     * @description Sets custom certificate for Web Server's SSL listener.
     * @description FQDN name from certificate are used for HTTPS link generation.
     * @param {*} { args }
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns
     */
  SetCustomCertificate ({ pCertData }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetCustomCertificate`,
      data: {pCertData},
      connection
    }, cacheConfig)
      .then(this.getResult)
  }
}
