const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'IamConnect'

module.exports = class IamConnect extends BaseOpenAPIClient {
  /**
   * Open a virtual/slave server connection or a connection to a host
   * @param {object} params
   * @param {string} params.connectionType - connection type (to virtualServer / slaveServer / host)
   * @param {string} params.strHostName - host name (for connectionType=host)
   * @param {string} params.strServerId - identity of virtual or slave server (for connectionType=virtualServer || connectionType=slaveServer)
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   * @constructor
   */
  async OpenConnection ({ connectionType, strHostName = null, strServerId = null }, connection, cacheConfig) {
    let path
    switch (connectionType) {
      case 'slaveServer':
        path = `/sessions/api/v1/servers/${strServerId}/sub`
        break
      case 'virtualServer':
        path = `/sessions/api/v1/servers/${strServerId}/virtual`
        break
      case 'host':
        path = `/sessions/api/v1/servers/${strHostName}/host`
        break
    }

    const result = await this.baseRequest({
      command: `${className}.OpenConnection`,
      data: {
        connectionType,
        strHostName,
        strServerId
      },
      path: path,
      connection
    }, cacheConfig)

    return result.body
  }
}
