const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'InvLicenseProducts'
module.exports = class InvLicenseProducts extends BaseOpenAPIClient {
  /**
     * @description Acquire License Products data.
     * @param {object} pParams - An object.
     * @param {array} pParams.KLINVLIC_LIC_PRODUCT_IDS_ARRAY collection long of products identifiers for which attributes is acquired. By default returns data for all products
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns {Promise}
     */
  async GetLicenseProducts ({ pParams = null }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${className}.GetLicenseProducts`,
      data: { pParams },
      connection
    }, cacheConfig))
  }
}
