const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'InventoryApi'

module.exports = class InventoryApi extends BaseOpenAPIClient {
  GetSrvCompetitorIniFileInfoList ({ wstrType } = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetSrvCompetitorIniFileInfoList`,
      data: {
        wstrType
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Acquire all software applications
   *
   * @param {object} pParams - Reserved but currently emprty properties container
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  GetInvProductsList (pParams, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetInvProductsList`,
      data: {
        pParams: null
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Acquire all software application updates
   *
   * @param {object} pParams - Reserved but currently emprty properties container
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  GetInvPatchesList (pParams, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetInvPatchesList`,
      data: {
        pParams: null
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /** Acquire list of observed applications
   * @param {object} params - method parameters
   * @param {Connection} connection - OpenAPI connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Array.<string>} pAppIds - collection of application `ProductID` */
  GetObservedApps (params, connection, cacheConfig) {
    return this.baseRequest({
      command: `${this.constructor.name}.GetObservedApps`,
      connection,
      data: { pParams: null }
    }, cacheConfig).then(this.deserialize)
  }

  /** Set list of observed applications
   * @param {object} params - method parameters
   * @param {Array.<string>} params.pAppIds - collection of application `ProductID`
   * @param {Connection} connection - OpenAPI connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {void} */
  SetObservedApps (params, connection, cacheConfig) {
    const { pAppIds } = params
    return this.baseRequest({
      command: `${this.constructor.name}.SetObservedApps`,
      connection,
      data: { pAppIds, pParams: null }
    }, cacheConfig).then(this.deserialize)
  }

  /** Remove from database info about software applications which aren't installed on any host
   * @param {object} params - method parameters
   * @param {Connection} connection - OpenAPI connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {void} */
  DeleteUninstalledApps (params, connection, cacheConfig) {
    return this.baseRequest({
      command: `${this.constructor.name}.DeleteUninstalledApps`,
      connection,
      data: { pParams: null }
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * Acquire software applications which are installed on specified host.
   * @param {object} params
   * @param { string } params.szwHostId host name, a unique server-generated string (see KLHST_WKS_HOSTNAME attribute). It is NOT the same as computer network name (DNS-, FQDN-, NetBIOS-name)
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  GetHostInvProducts ({ szwHostId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetHostInvProducts`,
      data: {
        pParams: null,
        szwHostId
      },
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * Acquire software application updates which are installed on specified host.
   * @param {object} params
   * @param { string } params.szwHostId host name, a unique server-generated string (see KLHST_WKS_HOSTNAME attribute). It is NOT the same as computer network name (DNS-, FQDN-, NetBIOS-name)
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  GetHostInvPatches ({ szwHostId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetHostInvPatches`,
      data: {
        pParams: null,
        szwHostId
      },
      connection
    }, cacheConfig).then(this.deserialize)
  }
}
