const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'KillChain'

module.exports = class KillChain extends BaseOpenAPIClient {
  GetByIDs ({ wstrHostID, wstrElementID }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetByIDs`,
      data: {
        wstrHostID,
        wstrElementID
      },
      connection
    }, cacheConfig).then(body => {
      const {
        result: { PxgRetVal: result, nResStatus }
      } = this.getBody(body)
      return { result, nResStatus }
    })
  }
}
