const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'KLEVerControl'

module.exports = class KLEVerControl extends BaseOpenAPIClient {
  ChangeCreatePackage ({
    vecDistribLocIdsToCreate = [],
    vecDistribLocIdsNotToCreate = []
  }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ChangeCreatePackage`,
      data: {
        vecDistribLocIdsToCreate,
        vecDistribLocIdsNotToCreate
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Initiate downloading of the distributive by URL into SC-server
   * Method is needed to download distributive by URL into SC-server
   * After that the distributive will be available to downloading from SC-server
   * @param {object} params
   * @param {number} params.lDistribLocId
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async DownloadDistributiveAsync ({ lDistribLocId }, connection, cacheConfig) {
    const response = await this.baseRequest({
      command: `${className}.DownloadDistributiveAsync`,
      data: {
        lDistribLocId
      },
      connection
    }, cacheConfig)
    const result = this.getResult(response)
    return result
  }

  /**
   * Get result of asynchronous operation DownloadDistributiveAsync
   * @param {object} params
   * @param {string} params.wstrRequestId
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {string} path to download distributive from SC-server using GET
   */
  async GetDownloadDistributiveResult ({ wstrRequestId }, connection, cacheConfig) {
    const response = await this.baseRequest({
      command: `${className}.GetDownloadDistributiveResult`,
      data: {
        wstrRequestId
      },
      connection
    }, cacheConfig)
    const result = this.getResult(response, 'wstrDownloadPath')
    return result
  }
}
