const GroupSyncIterator = require('./group-sync-iterator')

module.exports = class LicenseKeys extends GroupSyncIterator {
  /** Get an array of hosts that are currently using the specified key. */
  async AcquireKeyHosts ({ pInData, pFields, pFieldsToOrder, pOptions, lTimeoutSec }, connection, cacheConfig) {
    return this.deserialize(await this.getAllItems({
      command: `${this.constructor.name}.AcquireKeyHosts`,
      data: { pInData, pFields, pFieldsToOrder, pOptions, lTimeoutSec },
      connection
    }, cacheConfig))
  }

  /** Adjust adm. server's license attributes. */
  async AdjustKey ({ pData }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.AdjustKey`,
      data: { pData },
      connection
    }, cacheConfig))
  }

  /** Check if license can be installed to the adm. server.
   *  License is treated as a valid one if it is suitable for being used by the adm. server itself (its AppId is 1017, it is not expired etc.) */
  async CheckIfSaasLicenseIsValid ({ pInData, bAsCurrent }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.CheckIfSaasLicenseIsValid`,
      data: { pInData, bAsCurrent },
      connection
    }, cacheConfig))
  }

  /** Enumerate keys. */
  async EnumKeys ({ pFields, pFieldsToOrder, pOptions, lTimeoutSec }, connection, cacheConfig) {
    const rawResult = await this.getAllItems({
      command: `${this.constructor.name}.EnumKeys`,
      data: { pFields, pFieldsToOrder, pOptions, lTimeoutSec },
      connection
    }, cacheConfig)
    const result = this.deserialize(rawResult)
    return result
  }

  /** Get data of a key. */
  async GetKeyData ({ pKeyInfo }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.GetKeyData`,
      data: { pKeyInfo },
      connection
    }, cacheConfig))
  }

  /** Install a key on the server. */
  async InstallKey ({ pKeyInfo }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.InstallKey`,
      data: { pKeyInfo },
      connection
    }, cacheConfig))
  }

  /** Install an adm. server's license. */
  async SaasTryToInstall ({ pInData, bAsCurrent }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.SaasTryToInstall`,
      data: { pInData, bAsCurrent },
      connection
    }, cacheConfig))
  }

  /** Uninstall an adm. server's license. */
  async SaasTryToUninstall ({ bCurrent }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.SaasTryToUninstall`,
      data: { bCurrent },
      connection
    }, cacheConfig))
  }

  /** Uninstall a key from the adm. server. */
  async UninstallKey ({ pKeyInfo }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.UninstallKey`,
      data: { pKeyInfo },
      connection
    }, cacheConfig))
  }

  /**
   * @description Download license key files from activation key servers V1.
   * @param {object} params
   * @param {string} params.wstrActivationCode activation code in format XXXXX-XXXXX-XXXXX-XXXXX, mandatory.
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Array} array of license key files related to the specified code.
   */
  async DownloadKeyFiles ({ wstrActivationCode }, connection, cacheConfig) {
    return this.deserialize(await this.baseRequest({
      command: `${this.constructor.name}.DownloadKeyFiles`,
      data: { wstrActivationCode },
      connection
    }, cacheConfig))
  }
}
