const BaseOpenAPIClient = require('../base-open-api-client')

module.exports = class LicensePolicy extends BaseOpenAPIClient {
  /**
     * @description Check a functionality in restricted mode.
     * @param {object} obj - An object.
     * @param {number} obj.nFunctionality functionality for checking
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns {boolean} true if a functionality is in restricted mode, otherwise false
     */
  async IsLimitedMode ({ nFunctionality }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${this.constructor.name}.IsLimitedMode`,
      data: { nFunctionality },
      connection
    }, cacheConfig))
  }

  /**
     * @description Get total number of licenses for functionality.
     * @param {object} obj - An object.
     * @param {number} obj.nFunctionality functionality for checking
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns {number} total number of licenses
     */
  async GetTotalLicenseCount ({ nFunctionality }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${this.constructor.name}.GetTotalLicenseCount`,
      data: { nFunctionality },
      connection
    }, cacheConfig))
  }

  /**
     * @description Get number of free licenses for functionality.
     * @param {object} obj - An object.
     * @param {number} obj.nFunctionality functionality for checking
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns {number} number of free licenses
     */
  async GetFreeLicenseCount ({ nFunctionality }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${this.constructor.name}.GetFreeLicenseCount`,
      data: { nFunctionality },
      connection
    }, cacheConfig))
  }

  /**
     * @description Enable or disable restricted mode for functionality.
     * @param {object} obj - An object.
     * @param {number} obj.nFunctionality functionality for checking
     * @param {boolean} obj.bLimited true enable restricted mode for functionality, false for disable
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     */
  async SetLimitedModeTest ({ nFunctionality, bLimited }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${this.constructor.name}.SetLimitedModeTest`,
      data: { nFunctionality },
      connection
    }, cacheConfig))
  }

  /**
     * @description Set total number of licenses for functionality in restricted mode.
     * @param {object} obj - An object.
     * @param {number} obj.nFunctionality functionality for checking
     * @param {number} obj.nCount total number of licenses
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     */
  async SetTotalLicenseCountTest ({ nFunctionality, nCount }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${this.constructor.name}.SetTotalLicenseCountTest`,
      data: { nFunctionality },
      connection
    }, cacheConfig))
  }

  /**
     * @description Set number of used licenses for functionality in restricted mode.
     * @param {object} obj - An object.
     * @param {number} obj.nFunctionality functionality for checking
     * @param {number} obj.nCount number of used licenses
     * @param {*} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     */
  async SetUsedLicenseCountTest ({ nFunctionality, nCount }, connection, cacheConfig) {
    return this.getResult(await this.baseRequest({
      command: `${this.constructor.name}.SetUsedLicenseCountTest`,
      data: { nFunctionality },
      connection
    }, cacheConfig))
  }
}
