const BaseOpenApiClient = require('../base-open-api-client')
const className = 'Limits'

module.exports = class Limits extends BaseOpenApiClient {
  /**
   * Methods for memoization
   * @returns {[]}
   */
  get memoizeMethods () {
    return ['GetLimits']
  }

  /**
   * @description Returns a limit of specified parameter
   * @param {object} params
   * @param {number} params.param Parameter ID (integer), see OpenAPI docs for limited parameters values
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   */
  async GetLimits ({ param }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetLimits`,
      data: { param },
      connection
    }, cacheConfig)
    return this.deserialize(body)
  }
}
