const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'MdmCertCtrlApi'
module.exports = class MdmCertCtrlApi extends BaseOpenAPIClient {

  /**
   * @method CancelGeneratePackage2
   * Cancel SetCertificateAsync::GeneratePackageAsync2 operation.
   * Cancels asynchronous operation SetCertificateAsync.GeneratePackageAsync2.
   * @param {any} params - method parameters container
   * @param {string} params.wstrRequestId - identity of asynchronous operation
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Null} no return value if operation completed, error if failed
   */
  CancelGeneratePackage2 ({ wstrRequestId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CancelGeneratePackage2`,
      data: { wstrRequestId },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * @method CancelSetCertificate2
   * Cancel SetCertificateAsync::SetCertificateAsync2 operation.
   * Cancels asynchronous operation SetCertificateAsync.SetCertificateAsync2.
   * @param {any} params - method parameters container
   * @param {String} params.wstrRequestId - identity of asynchronous operation
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Null} no return value if operation completed, error if failed
   */
  CancelSetCertificate2 ({ wstrRequestId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CancelSetCertificate2`,
      data: { wstrRequestId },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * @method CheckMailNotificationSettings
   * Check email settings.
   * @param {any} params - method parameters container
   * @param {Boolean} params.bCheckMainServerDefaults - It defines if virtual server's email settings should be checked
   * in merge (as defaults) with main server's email settings.
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Boolean} true if email settings are OK (if SMTP server address are not empty)
   */
  CheckMailNotificationSettings ({ bCheckMainServerDefaults }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CheckMailNotificationSettings`,
      data: { bCheckMainServerDefaults },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method CheckPkiAccount
   * Check if PKI account is valid.
   * @param {any} params - method parameters container
   * @param {Boolean} params.wsAccountName - PKI account's name
   * @param {any} params.pAccountPwd - PKI account's password (encrypted)
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Number} PKI account check result
   */
  CheckPkiAccount ({ wsAccountName, pAccountPwd }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CheckPkiAccount`,
      data: this.serialize({ wsAccountName, pAccountPwd }),
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method CheckPkiEnabled
   * Check if PKI enabled.
   * @param {Null} _ - null argument
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Boolean} True if PKI enabled
   */
  CheckPkiEnabled (_, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CheckPkiEnabled`,
      data: null,
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method DeleteCertificates
   * Delete certificate by id.
   * @param {any} params - method parameters container
   * @param {Array<Number>} params.pIds - array of certificate Ids (Number) to remove
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Null} no return value if operation completed, error if failed
   */
  DeleteCertificates ({ pIds }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DeleteCertificates`,
      data: this.serialize({ pIds }),
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * @method GeneratePackageAsync2
   * Publishes installation packages for the users.
   * @param {any} params - method parameters container
   * @param {any} params.pPackageInfo - contains protocol-specific package information if required.
   * @param {any} params.pCertificate - certificate parameters
   * @param {Array<any>} params.pRecipients - array of notification recipients
   * @param {any} params.pNotification - method of notifying the user
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {String} identity of asynchronous operation
   */
  GeneratePackageAsync2 ({ pPackageInfo, pCertificate, pRecipients, pNotification }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GeneratePackageAsync2`,
      data: this.serialize({ pPackageInfo, pCertificate, pRecipients, pNotification }),
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method GetCertificatePublic
   * Retrieve certificate's public part.
   * @param {any} params - method parameters container
   * @param {any} params.nCertId - certificate id to get (paramLong)
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {any} Certificate
   */
  GetCertificatePublic ({ nCertId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetCertificatePublic`,
      data: this.serialize({ nCertId }),
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method GetIssuanceSettings
   * Retrieve saved issuance settings for certificate types.
   * @param {Null} _ - null argument
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Array} array (paramArray) of issuance settings
   */
  GetIssuanceSettings (_, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetIssuanceSettings`,
      data: null,
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method GetIssuanceSettingsByType
   * Retrieve saved issuance settings for specific certificate type.
   * @param {any} params - method parameters container
   * @param {any} params.nCertType - certificate type (paramLong)
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {any} issuance settings
   */
  GetIssuanceSettingsByType ({ nCertType }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetIssuanceSettingsByType`,
      data: this.serialize({ nCertType }),
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method GetPackagesByPackageProduct
   * Retrieve package list by package product name and version.
   * @param {any} params - method parameters container
   * @param {String} params.wsPkgProductName - product name
   * @param {String} params.wsPkgProductVersion - product version
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Array<any>} package list. Each item of list contains package information.
   */
  GetPackagesByPackageProduct ({ wsPkgProductName, wsPkgProductVersion }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetPackagesByPackageProduct`,
      data: { wsPkgProductName, wsPkgProductVersion },
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method GetPkiTemplates
   * Get PKI templates.
   * @param {any} params - method parameters container
   * @param {Boolean} params.bForceReload - if True then templates will be reloaded from AD, False - loaded from cache
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Array<any>} array of templates
   */
  GetPkiTemplates ({ bForceReload }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetPkiTemplates`,
      data: { bForceReload },
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method GetPkiTemplatesByEKU
   * Get PKI templates filtered by EKU.
   * @param {any} params - method parameters container
   * @param {String} params.wsEKU - extended key usage
   * @param {Boolean} params.bForceReload - if True then templates will be reloaded from AD, False - loaded from cache
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Array<any>} array of templates
   */
  GetPkiTemplatesByEKU ({ wsEKU, bForceReload }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetPkiTemplatesByEKU`,
      data: { wsEKU, bForceReload },
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method GetRestoreData
   * Get mobile device restore data.
   * @param {any} params - method parameters container
   * @param {String} params.wstrDeviceHostName - name of device
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {any} restore data
   */
  GetRestoreData ({ wstrDeviceHostName }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetRestoreData`,
      data: { wstrDeviceHostName },
      connection
    }, cacheConfig).then(this.deserialize)
  }

  /**
   * @method RenewCertificate
   * Renew certificate.
   * Renew's certificate, in case if certificate was used in iOS MDM profile then profile will be renewed also.
   * @param {any} params - method parameters container
   * @param {Number} params.nCertId - certificate id to renew
   * @param {any} params.pCertificate - certificate parameters
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Null} no return value if operation completed, error if failed
   */
  RenewCertificate ({ nCertId, pCertificate }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.RenewCertificate`,
      data: this.serialize({ nCertId, pCertificate }),
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * @method SetCertificateAsync2
   * Set user's certificate.
   * Saves caller-defined certificate or server-generated self-signed certificate.
   * Generates one-time password if required.
   * Notifies user by Mail, SMS or both about prepared certificate and method of authorization.
   * Certificate provided by caller may be applied only to one certificate type to one recipient. If request contains
   * more than one recipient, provided certificates will be ignored.
   * @param {any} params - method parameters container
   * @param {any} params.pAuthType - KES only! Authentication method for user.
   * @param {any} params.Notification - method of notifying the user
   * @param {any} params.pCertificate - certificate parameters
   * @param {Array} params.pRecipient - array of notification recipients
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {String} wstrRequestId - identity of asynchronous operation
   */
  SetCertificateAsync2 ({ pAuthType, pNotification, pCertificate, pRecipient }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetCertificateAsync2`,
      data: {
        pAuthType: this.serialize(pAuthType),
        pNotification: this.serialize(pNotification),
        pCertificate: this.serialize(pCertificate),
        pRecipient: this.serialize(pRecipient)
      },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method SetCertificateTag
   * Sets certificate tag.
   * It is useful for Mail/VPN iOS certificates only!
   * @param {any} params - method parameters container
   * @param {Number} params.nCertId - certificate id
   * @param {String} params.wstrCertTag - certificate id
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Boolean} True in case of success.
   */
  SetCertificateTag ({ nCertId, wstrCertTag }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetCertificateTag`,
      data: { nCertId, wstrCertTag },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method UpdateIssuanceSettings
   * Update issuance settings for specific certificate types.
   * @param {any} params - method parameters container
   * @param {Array} params.pCertTypes - array of issuance settings
   * @param {Connection} connection - connection object
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Null} no return value if operation completed, error if failed
   */
  UpdateIssuanceSettings ({ pCertTypes }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.UpdateIssuanceSettings`,
      data: this.serialize({ pCertTypes }),
      connection
    }, cacheConfig).then(this.getResult)
  }
}
