const BaseOpenAPIGatewayClient = require('../base-open-api-gateway-client')
const className = 'NagGuiCalls'

module.exports = class NagGuiCalls extends BaseOpenAPIGatewayClient {
  /**
   * Asynchronously connects to the remote host (if hasn't connected yet), and makes call with the specified name szwCallName
   * @param {object} params
   * @param {string} params.szwProduct - product name
   * @param {string} params.szwVersion - product settings compatibility version
   * @param {string} params.szwCallName - remote call name
   * @param {object} params.pInData - call-specific input data
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise} - asynchronous request ID, used to get the result
   */
  CallConnectorAsync ({ szwProduct, szwVersion, szwCallName, pInData, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CallConnectorAsync`,
      data: {
        szwProduct,
        szwVersion,
        szwCallName,
        pInData
      },
      connectionId
    }, cacheConfig).then(this.getBody)
  }
}
