const BaseOpenAPIGatewayClient = require('../base-open-api-gateway-client')
const className = 'NagHstCtl'

module.exports = class NagHstCtl extends BaseOpenAPIGatewayClient {
  GetHostRuntimeInfo ({ pFilter, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetHostRuntimeInfo`,
      data: {
        pFilter: this.serialize(pFilter)
      },
      connectionId
    }, cacheConfig)
      .then(this.deserialize)
  }

  SendProductAction ({ szwProduct, szwVersion, nProductAction, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SendProductAction`,
      data: {
        szwProduct,
        szwVersion,
        nProductAction
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }

  SendTaskAction ({ szwProduct, szwVersion, szwTaskStorageId, nTaskAction, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SendTaskAction`,
      data: {
        szwProduct,
        szwVersion,
        szwTaskStorageId,
        nTaskAction
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }
}
